* Do-fil til kapittel 6
use "https://nedlasting.fagbokforlaget.no/stata/xy12.dta", clear
list   /* Lister alle variabler for alle enheter */
summ  /* Beskrivende statistikk */
pwcorr x y, sig
* Spredningsdiagram
twoway (scatter y x)(lfit y x), ytitle("Timelønn")
* Enkel, bivariat regresjon
reg y x
* Regresjonsanalyse av timelønn, abu89.dta
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
summ time89 ed age female
regress time89 ed
regress time89 ed age
* Blokkvis regresjon med nestreg
nestreg: regress time89 (ed) (age female)
* Standardiserte regresjonskoeffisienter
regress time89 ed age female, beta
test age female   /* Wald test */
* Regresjon med en kategorivariabel med prefiks "i"
regress time89 ed age female i.klasse89
contrast klasse89   /* Wald test for klasse89 */
* Gruppevis regresjonsanalyse
sort female
by female: regress time89 ed age
* Teste forskjeller i koeffisienter med suest
regress time89 ed age if female==1
estimates store kvinner
regress time89 ed age if female==0
estimates store menn
suest kvinner menn
test [menn_mean]ed=[kvinner_mean]ed
* Forutsetningen om lineariter for alder
* twoway (scatter time89 age)(lfit time89 age), ytitle("Timelønn")
quietly: regress time89 age
predict pred_lin
lowess time89 age, gen(pred_low) 
** Begge linjene i samme scatter plot
twoway (scatter time89 age)(lfit time89 age) ///
   (line pred_low age, sort), ytitle("Timelønn")
* ovtest: Ramseys RESET
regress time89 age
estat ovtest, rhs
* 2.gradsledd av alder
generate age2 = age^2
label variable age2 "Alder kvadrert"
regress time89 age age2
predict pred_kvad  /* Predikerte verdier lagres */
* Tre linjer i samme diagram
twoway (line pred_lin age)(line pred_kvad age, sort) ///
   (line pred_low age, sort), ytitle("Timelønn") ///
   xlabel(20 30 40 50 60 70 80)
* To måter å sette opp samme modell
regress time89 ed c.age c.age#c.age female           
regress time89 ed c.age##c.age female
margins, at(age=(16(1)74))
marginsplot
marginsplot, noci
marginsplot, recast(line) recastci(rarea)
* Variasjoner i regresjonskoeffisienten til age
regress time89 ed c.age##c.age female
margins, at(age=30) dydx(age)
margins, at(age=(20(10)70)) dydx(age)
* Figur 9.8
regress time89 ed c.age##c.age female
gen py40 = 71 + 0.607*age   /* regresjonsinje ved 40 år */
margins, at(age=(16(1)74))
marginsplot, noci recast(line) addplot (line py40 age, sort) ///
   xline(40) xlabel(20 30 40 50 60 70) 
** Er sammenhengen mellom timelønn og utdanning lineær?
regress time89 i.ed c.age##c.age female
margins ed
marginsplot, noci recast(line) addplot (lfit time89 ed)
lowess time89 ed
** Er det samspill mellom utdanning og kjønn?
regress time89 c.age##c.age c.ed##female
contrast c.ed#female
margins female, at(ed=(0(1)11))
marginsplot, noci
marginsplot, recast(line) recastci(rarea)
marginsplot, noci recast(line)   /* Figur 6.11 */
*** Homoskedastisitet
regress time89 c.age##c.age c.ed##female
rvfplot, msize(small)   /* Figur 6.12 */
estat hettest
*** Residualer of diagnoseplott
predict res, resid
predict zres, rstandard
histogram zres, frequency normal  /* Figur 6.13 */
histogram zres, percent normal
pnorm res     /* Normal probability plot figur 6.14 */
*****************************
*** Merk at figurene 6.15 og 6.16 er basert på xy.dta.
*** Kommandoen er gjengitt nederst i filen
*****************************
*** plots basert på regresjon i abu89.dta
**********
regress time89 c.age##c.age c.ed##female 
avplot ed, msize(small)  /* Figur 6.17 */
lvr2plot, msize(small) mlabel(io_nr) /* Figur 6.18 */
*** ekstremerdier lagres
predict residual, resid
predict rs, rstudent
predict lev, leverage
predict cook, cooksd
*** dfbetas lagres og det lages oppsummerende statistikk
dfbeta
summ _dfbeta_1 _dfbeta_2 _dfbeta_3 _dfbeta_4 _dfbeta_5
sort _dfbeta_3
list io_nr _dfbeta_3  if _dfbeta_3 > 0.20 & _dfbeta_3 <.
* re-estimerer modellen uten 5 enheter med høye dfbeta
regress time89 c.age##c.age c.ed##female if _dfbeta_3 < 0.20
* sammenlign 4,55 med resultatet 4,84 fra den originale modllen
regress time89 c.age##c.age c.ed##female
*
*********************
* Multikolinearitet
******
generate age2 = age^2
generate edfem = ed*female
pwcorr ed age age2 female edfem
regress time89 c.age##c.age c.ed##female
estat vif
* Robust regresjon
rreg time89 c.age##c.age c.ed##female
*
******* tranformasjoner
* potenstransformasjoner med tester som ikke fungerer
ladder time89
*** grafisk framstilling av transformerte variabler
gladder time89   /* Figur 6.19  */
*
gen ltime89 = ln(time89)   /* naturlig log av time89 */
* Estimere modellen med ltime89 
regress ltime89 c.age##c.age c.ed##female
** Estimere modellen om igjen uten samspill
regress ltime89 ed c.age##c.age female
rvfplot, msize(small)
*
* Formatterte regresjonstabeller
* eststo opg esttab
eststo: quietly regress time89 age female ed
eststo: quietly regress time89 age female ed fexp private
* Tabell med standardfeil under regresjonskoeffisientene
* Versjon med variabelnavn
esttab, ar2
* Versjon med variabeletiketter
esttab, ar2 label
* Tabell med standardfeil ved siden av regresjonskoeffisientene
* Versjon med variabelnavn
esttab, ar2 wide
* Versjon med variabeletiketter
esttab, ar2 wide label
*
*****************************
*** diagnoseplott fil xy12.dta
regress y x
avplot x, mlabel(id)  /* Figur 6.15 */
lvr2plot, mlabel(id)  /* Figur 6.16 */
*** ekstremverdier og innflytelse, statistiske størrelser
help regression postestimation
predict residual, resid
predict rs, rstudent
predict lev, leverage
predict cook, cooksd
dfbeta ed
sort y
list
regress y x
regress y x if id !=11
***************************************
